% finaquant Analytics - www.finaquant.com
% Copyright: Tunc Ali Ktkcoglu 2012, version: 12July2012
% Download at:
% http://finaquant.com/download
% Email: fqcontact@finaquant.com
function TestData = generate_independent_attribute_combinations(AttributeValues, AttributeNames)
% Generate test data (cell matrix) as cartesian multiplication of 
% (independent) attribute values
% Input argument AttributeValues is a cell array containing the list
% of attribute values, for example:
% AttributeNames = {'car', 'color', 'type'}
% AttributeValues{1} = {'BMW', 'Toyota', 'Audi', 'Renault'} 
% AttributeValues{2} = {'blue', 'black', 'gray', 'green'} 
% AttributeValues{3} = {'sports', 'luxury', 'economy'} 

% check array sizes
if length(AttributeValues) ~= length(AttributeNames)
    error 'Mismatch in the sizes of input arrays!'
end

% initiate and set counter limits
CounterLimits = zeros(1, length(AttributeNames));
RowCount = 1;   % row size of test matrix; total number of attribute combinations
for i=1:length(AttributeNames)
    CounterLimits(i) = length(AttributeValues{i});
    RowCount = RowCount * length(AttributeValues{i});
end

% obtain all possible attribute value combinations
LimitAchieved = false;
MultiStepCountVec = [];
TestData = cell(RowCount, length(AttributeNames));
RowCtr = 1;

while ~ LimitAchieved
    [MultiStepCountVec, LimitAchieved] = increment_MultiRegister_counter(MultiStepCountVec, CounterLimits); 
    
    for i=1:length(MultiStepCountVec)
        TestData{RowCtr, i} = AttributeValues{i}{MultiStepCountVec(i)};
    end
    
    RowCtr = RowCtr + 1;
end
TestData = [AttributeNames; TestData];

